//------------------------------------------------------------------------------
// File: svr_inventory.cs
// This file contains the server methods for the player inventory
// Author: Matthew Rudge
//------------------------------------------------------------------------------

$INV_SVRSELECTITEM = "";

////////////////////////////////////////////////////////////////////////////////
//! Initializes the client's inventory
//! \param %client Client for which to initialize inventory
////////////////////////////////////////////////////////////////////////////////
function invInitClientInventory(%client)
{
   // Create inventory with slot count
   invCreateInventory(%client, $INV_SLOTCOUNT);
   commandToClient(%client, 'CreateInventory', $INV_SLOTCOUNT);
   
   // Place each item into inventory (%i + 1 corresponds to *$INV_* above)
   for(%i = 0; %i < $INV_SLOTCOUNT; %i++) {
      invPlaceItemInInventory(%client, %i, %i + 1, 0);
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Destroys the client's inventory
//! \param %client Client for which to destory inventory
////////////////////////////////////////////////////////////////////////////////
function invDestroyClientInventory(%client)
{
   invDestroyInventory(%client);
   commandToClient(%client, 'DestroyInventory');
}

////////////////////////////////////////////////////////////////////////////////
//! Places zero or more items into a client's inventory
//! \param %client Client
//! \param %slot Slot for item
//! \param %item Item id
//! \param %amount Number of items
////////////////////////////////////////////////////////////////////////////////
function invPlaceItemInInventory(%client, %slot, %item, %amount)
{
   invPlaceItem(%client, %slot, %item, %amount);
   commandToClient(%client, 'PlaceItemInInventory', %slot, %item, %amount, invGetItemStackMax(%client, %slot));
}

////////////////////////////////////////////////////////////////////////////////
//! Checks if another item can be added to the stack at the specified slot
//! \param %client Client with inventory
//! \param %slot Slot for item
//! \retval bool True if an item can be added to the stack
////////////////////////////////////////////////////////////////////////////////
function invCanPushItem(%client, %slot)
{
   return (invGetItemStackCount(%client, %slot) < invGetItemStackMax(%client, %slot));
}

////////////////////////////////////////////////////////////////////////////////
//! Pushes an item onto the item stack located at the specified slot
//! \param %client Client with inventory
//! \param %slot Slot for item
////////////////////////////////////////////////////////////////////////////////
function invPushItemInInventory(%client, %slot)
{
   invPushItemOnStack(%client, %slot);
   commandToClient(%client, 'PushItemInInventory', %slot);
}

////////////////////////////////////////////////////////////////////////////////
//! Pops an itme from the item stack located at the specified slot
//! \param %client Client with inventory
//! \param %slot Slot for item
//! \retval int Item id in slot
////////////////////////////////////////////////////////////////////////////////
function invPopItemInInventory(%client, %slot)
{
   %item = invPopItemFromStack(%client, %slot);
   commandToClient(%client, 'PopItemInInventory', %slot);
   return %item;
}

////////////////////////////////////////////////////////////////////////////////
//! Saves a client's inventory
//! \param %client Client for which to save inventory
////////////////////////////////////////////////////////////////////////////////
function invSaveClientInventory(%client)
{
   // Write slot count
   // For each slot do
      // Write out item count
}

////////////////////////////////////////////////////////////////////////////////
//! Loads a client's saved inventory
//! \param %client Client for which to load inventory
////////////////////////////////////////////////////////////////////////////////
function invLoadClientInventory(%client)
{
   // Read slot count
   // For each slot do
      // Read and set item count
}

////////////////////////////////////////////////////////////////////////////////
//! Returns the currently selected item for a client
//! \param %client Client with selected item
//! \retval int Item id or ""
////////////////////////////////////////////////////////////////////////////////
function invServerGetSelectedItem(%client)
{
   return $INV_SVRSELECTITEM[%client];
}

////////////////////////////////////////////////////////////////////////////////
//! Selects an item on the server for a client
//! \param %client Client with selected item
//! \param %item Item id
////////////////////////////////////////////////////////////////////////////////
function invServerSelectItem(%client, %item)
{
   $INV_SVRSELECTITEM[%client] = %item;
   commandToClient(%client, 'ItemSelected', %item);
}

////////////////////////////////////////////////////////////////////////////////
//! Unselects an item on the server
//! \param %client Client with selected item
////////////////////////////////////////////////////////////////////////////////
function invServerUnselectItem(%client)
{
   $INV_SVRSELECTITEM[%client] = "";
}

//-Client Command Methods-------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Notification when a client attempts to select an item in a slot
//! \param %client Client that issued request
//! \param %slot Slot for item
////////////////////////////////////////////////////////////////////////////////
function serverCmdSelectInventoryItem(%client, %slot)
{
   if(invCanPopItem(%client, %slot))
   {
      %item = invPopItemInInventory(%client, %slot);
      invServerSelectItem(%client, %item);
   }
   else
   {
      csCmdStatusFail(%client, $CSC_TOOL);
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Notification when a client unselects an item
//! \param %client Client that issued request
////////////////////////////////////////////////////////////////////////////////
function serverCmdUnselectInventoryItem(%client)
{
   // Get slot for current item
   %slot = invGetSlotForItem(%client, invServerGetSelectedItem(%client));
   if(%slot < 0) {
      return;
   }
   
   // Place item back in inventory
   invPushItemInInventory(%client, %slot);
   invServerUnselectItem(%client);
}
//------------------------------------------------------------------------------



// End svr_inventory.cs